IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_PROCESSAR]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_PROCESSAR];
GO

GO
/*
	Esta procedure esta sendo executada dentro da procedure P_PDV_CONSLD_VD_MOVIMENTO_GERACAO_EXECUTE_ALL
*/
--EXEC P_RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_PROCESSAR
CREATE PROCEDURE P_RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_PROCESSAR 
WITH ENCRYPTION
AS
DECLARE @CD_CLI INT
DECLARE @CD_FILIAL INT
DECLARE @DT_PGTO DATETIME
DECLARE @VLR_BAIXA MONEY
DECLARE @VLR_ANTECIPACAO MONEY
DECLARE @VLR_ADMINISTRACAO MONEY
DECLARE @BANCO INT
DECLARE @AGENCIA INT
DECLARE @CONTA INT
DECLARE @CD_EMP INT
DECLARE @CD_CTR_LOTE_PAGTO_AGRUPAMENTO INT
DECLARE @NM_ADMINISTRADORA VARCHAR(300)
DECLARE @TP_ADM INT

SET NOCOUNT ON;

--Retirando pedencia que ja foi processada
DELETE
	RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA
FROM
	RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL INNER JOIN RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA ON
	RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_CTR_LOTE = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA.CD_CTR_LOTE AND
	RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_EMP = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA.CD_EMP AND
	RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_FILIAL = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA.CD_FILIAL AND
	RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_VD = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA.CD_VD AND
	RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_CTR = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA.CD_CTR 
--Fim

CREATE TABLE #TefConfPagamento(CD_CTR_LOTE INT,
							   CD_EMP INT,
							   CD_FILIAL INT,
							   CD_CLI INT,
							   CD_VD INT,
							   CD_CTR INT,
							   BANCO INT,
							   AGENCIA INT,
							   CONTA INT,
							   DT_PGTO DATETIME,
							   VLR_BAIXA MONEY,
							   VLR_ANTECIPACAO MONEY,
							   VLR_ADMINISTRACAO MONEY,
							   TP_ADM INT)


INSERT INTO #TefConfPagamento
	(CD_CTR_LOTE,
	CD_EMP,
	CD_FILIAL,
	CD_CLI,
	CD_VD,
	CD_CTR,
	BANCO,
	AGENCIA,
	CONTA,
	DT_PGTO,
	VLR_BAIXA,
	VLR_ANTECIPACAO,
	VLR_ADMINISTRACAO,
	TP_ADM)
SELECT
	tefconc.CD_CTR_LOTE,
	tefconc.CD_EMP,
	tefconc.CD_FILIAL,
	RC_CLI.CD_CLI, 
	tefconc.CD_VD,
	tefconc.CD_CTR,
	tefconc.BANCO,
	tefconc.AGENCIA,
	tefconc.CONTA,
	tefconc.DT_PGTO,
	tefconc.VLR_BAIXA,
	tefconc.VLR_ANTECIPACAO,
	tefconc.VLR_ADMINISTRACAO,
	RC_ADM_CARTAO.TP_ADM
FROM
	RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL tefconc INNER JOIN RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA ON
	tefconc.CD_CTR_LOTE = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA.CD_CTR_LOTE AND
	tefconc.CD_EMP = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA.CD_EMP AND
	tefconc.CD_FILIAL = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA.CD_FILIAL AND
	tefconc.CD_VD = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA.CD_VD  AND
	tefconc.CD_CTR = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL_PENDENCIA.CD_CTR 
	INNER JOIN PDV_VD_TEF ON
	tefconc.CD_EMP = PDV_VD_TEF.CD_EMP AND
	tefconc.CD_FILIAL = PDV_VD_TEF.CD_FILIAL AND
	tefconc.CD_VD = PDV_VD_TEF.CD_VD  AND
	tefconc.CD_CTR = PDV_VD_TEF.CD_CTR 
	INNER JOIN PDV_VD ON
	tefconc.CD_EMP = PDV_VD.CD_EMP AND
	tefconc.CD_FILIAL = PDV_VD.CD_FILIAL AND
	tefconc.CD_VD = PDV_VD.CD_VD 
	INNER JOIN RC_ADM_CARTAO ON
	PDV_VD_TEF.CD_EMP = RC_ADM_CARTAO.CD_EMP AND
	PDV_VD_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO 
	INNER JOIN RC_ADM_CARTAO_RC_CLI ON
	RC_ADM_CARTAO.CD_EMP = RC_ADM_CARTAO_RC_CLI.CD_EMP AND
	RC_ADM_CARTAO.CD_ADM_CARTAO = RC_ADM_CARTAO_RC_CLI.CD_ADM_CARTAO 
	INNER JOIN RC_CLI ON
	RC_ADM_CARTAO_RC_CLI.CD_EMP = RC_CLI.CD_EMP AND
	RC_ADM_CARTAO_RC_CLI.CD_CLI = RC_CLI.CD_CLI

	DECLARE CCriaLote CURSOR FAST_FORWARD FOR
	SELECT
		RC_CLI.CD_CLI ,
		RC_CLI.NM_FANT, 
		tefconc.CD_EMP,
		tefconc.CD_FILIAL,
		tefconc.DT_PGTO, 
		tefconc.BANCO,
		tefconc.AGENCIA,
		tefconc.CONTA,
		SUM(tefconc.VLR_BAIXA) AS VLR_BAIXA,
		SUM(tefconc.VLR_ANTECIPACAO) AS VLR_ANTECIPACAO, 
		SUM(tefconc.VLR_ADMINISTRACAO) AS  VLR_ADMINISTRACAO,
		RC_ADM_CARTAO.TP_ADM 
	FROM
		#TefConfPagamento tefconc INNER JOIN PDV_VD_TEF ON
		tefconc.CD_EMP = PDV_VD_TEF.CD_EMP AND
		tefconc.CD_FILIAL = PDV_VD_TEF.CD_FILIAL AND
		tefconc.CD_VD = PDV_VD_TEF.CD_VD  AND
		tefconc.CD_CTR = PDV_VD_TEF.CD_CTR 
		INNER JOIN PDV_VD ON
		tefconc.CD_EMP = PDV_VD.CD_EMP AND
		tefconc.CD_FILIAL = PDV_VD.CD_FILIAL AND
		tefconc.CD_VD = PDV_VD.CD_VD 
		INNER JOIN RC_ADM_CARTAO ON
		PDV_VD_TEF.CD_EMP = RC_ADM_CARTAO.CD_EMP AND
		PDV_VD_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO 
		INNER JOIN RC_ADM_CARTAO_RC_CLI ON
		RC_ADM_CARTAO.CD_EMP = RC_ADM_CARTAO_RC_CLI.CD_EMP AND
		RC_ADM_CARTAO.CD_ADM_CARTAO = RC_ADM_CARTAO_RC_CLI.CD_ADM_CARTAO 
		INNER JOIN RC_CLI ON
		RC_ADM_CARTAO_RC_CLI.CD_EMP = RC_CLI.CD_EMP AND
		RC_ADM_CARTAO_RC_CLI.CD_CLI = RC_CLI.CD_CLI
	GROUP BY
		RC_CLI.CD_CLI ,
		RC_CLI.NM_FANT, 
		tefconc.DT_PGTO,
		tefconc.CD_EMP,
		tefconc.CD_FILIAL,
		tefconc.BANCO,
		tefconc.AGENCIA,
		tefconc.CONTA,
		RC_ADM_CARTAO.TP_ADM 
	order by
		CD_CLI,
		DT_PGTO

	OPEN CCriaLote;
	FETCH NEXT FROM CCriaLote INTO  @CD_CLI,
									@NM_ADMINISTRADORA,
									@CD_EMP,
									@CD_FILIAL,
									@DT_PGTO,
									@BANCO,
									@AGENCIA,
									@CONTA,
									@VLR_BAIXA,
									@VLR_ANTECIPACAO,
									@VLR_ADMINISTRACAO,
									@TP_ADM;

	WHILE @@FETCH_STATUS = 0
		BEGIN
			PRINT 'Cria lote pagamento administradora ' + CONVERT(VARCHAR(max), @NM_ADMINISTRADORA) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
			
			SET @CD_CTR_LOTE_PAGTO_AGRUPAMENTO = ISNULL((SELECT 
															TOP 1 CD_CTR_LOTE_PGTO_AGRUPAMENTO
														 FROM
															RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO
														 WHERE
															CD_EMP=@CD_EMP
															AND CD_FILIAL=@CD_FILIAL
															AND BANCO=@BANCO
															AND AGENCIA=@AGENCIA
															AND CONTA=@CONTA
															AND DT_PGTO=@DT_PGTO
															AND CD_CLI=@CD_CLI
															AND TP_ADM=@TP_ADM),0)
			IF @CD_CTR_LOTE_PAGTO_AGRUPAMENTO=0
			BEGIN
				INSERT INTO RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO
				(CD_EMP,
				CD_FILIAL,
				CD_CLI,
				DT_PGTO,
				BANCO,
				AGENCIA,
				CONTA,
				DT_CAD,
				VLR_BAIXA,
				VLR_ADMINISTRACAO,
				VLR_ANTECIPACAO,
				TP_ADM)
				SELECT
					@CD_EMP,
					@CD_FILIAL,
					@CD_CLI,
					@DT_PGTO,
					@BANCO,
					@AGENCIA,
					@CONTA,
					GETDATE(),
					@VLR_BAIXA,
					@VLR_ADMINISTRACAO,
					@VLR_ANTECIPACAO,
					@TP_ADM

				SET @CD_CTR_LOTE_PAGTO_AGRUPAMENTO = (SELECT IDENT_CURRENT('RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO'))
			END

			INSERT INTO RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL
				(CD_CTR_LOTE_PGTO_AGRUPAMENTO,
				CD_CTR_LOTE,
				CD_EMP,
				CD_FILIAL,
				CD_VD,
				CD_CTR,
				DT_CAD)
			SELECT
				@CD_CTR_LOTE_PAGTO_AGRUPAMENTO,
				CD_CTR_LOTE,
				CD_EMP,
				CD_FILIAL,
				CD_VD,
				CD_CTR,
				GETDATE()
			FROM
				#TefConfPagamento
			WHERE
				CD_EMP=@CD_EMP
				AND CD_FILIAL=@CD_FILIAL
				AND BANCO=@BANCO
				AND AGENCIA=@AGENCIA
				AND CONTA=@CONTA
				AND DT_PGTO=@DT_PGTO
				AND CD_CLI=@CD_CLI 
				AND TP_ADM=@TP_ADM

				--Update e necessario pois havera casos em que sera apenas incluido os dados de baixa
				--Onde devera refazer os dados do lote de pagamento conciliacao
				UPDATE
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO
				SET 
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO.VLR_BAIXA=RS.VLR_BAIXA,
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO.VLR_ADMINISTRACAO=RS.VLR_ADMINISTRACAO,
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO.VLR_ANTECIPACAO=RS.VLR_ANTECIPACAO  
				FROM
				(SELECT
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_CTR_LOTE_PGTO_AGRUPAMENTO,
					SUM(RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL.VLR_BAIXA) AS VLR_BAIXA,
					SUM(RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL.VLR_ADMINISTRACAO) AS VLR_ADMINISTRACAO,
					SUM(RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL.VLR_ANTECIPACAO ) AS VLR_ANTECIPACAO
				FROM
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL INNER JOIN RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL ON
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_CTR_LOTE = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL.CD_CTR_LOTE AND
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_EMP = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL.CD_EMP AND
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_FILIAL = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL.CD_FILIAL AND
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_VD = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL.CD_VD  AND
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_CTR = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_CPL.CD_CTR 
				WHERE
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_CTR_LOTE_PGTO_AGRUPAMENTO =@CD_CTR_LOTE_PAGTO_AGRUPAMENTO
				GROUP BY
					RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_CPL.CD_CTR_LOTE_PGTO_AGRUPAMENTO) RS INNER JOIN RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO ON
					RS.CD_CTR_LOTE_PGTO_AGRUPAMENTO = RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO.CD_CTR_LOTE_PGTO_AGRUPAMENTO 

	FETCH NEXT FROM CCriaLote INTO  @CD_CLI,
									@NM_ADMINISTRADORA,
									@CD_EMP,
									@CD_FILIAL,
									@DT_PGTO,
									@BANCO,
									@AGENCIA,
									@CONTA,
									@VLR_BAIXA,
									@VLR_ANTECIPACAO,
									@VLR_ADMINISTRACAO,
									@TP_ADM;
		END ;

	CLOSE CCriaLote ;
	DEALLOCATE CCriaLote 


drop TABLE #TefConfPagamento